/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.ILivestock;
import net.dries007.tfc.network.PacketSimpleMessage;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.entity.EntitiesTFC;
import net.dries007.tfc.objects.entity.animal.AnimalGroupingRules;
import net.dries007.tfc.objects.entity.animal.EntityAnimalMammal;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

@ParametersAreNonnullByDefault
public class EntityCowTFC
extends EntityAnimalMammal
implements ILivestock {
    private static final DataParameter<Long> MILKED = EntityDataManager.func_187226_a(EntityCowTFC.class, EntitiesTFC.getLongDataSerializer());

    public EntityCowTFC(World worldIn) {
        this(worldIn, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityCowTFC.getRandomGrowth(ConfigTFC.Animals.COW.adulthood, ConfigTFC.Animals.COW.elder));
    }

    public EntityCowTFC(World worldIn, IAnimalTFC.Gender gender, int birthDay) {
        super(worldIn, gender, birthDay);
        this.func_70105_a(1.2f, 1.3f);
        this.setMilkedTick(0L);
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!BiomesTFC.isOceanicBiome(biome) && !BiomesTFC.isBeachBiome(biome) && biomeType == BiomeHelper.BiomeType.PLAINS) {
            return ConfigTFC.Animals.COW.rarity;
        }
        return 0;
    }

    @Override
    public BiConsumer<List<EntityLiving>, Random> getGroupingRules() {
        return AnimalGroupingRules.MALE_AND_FEMALES;
    }

    @Override
    public int getMinGroupSize() {
        return 3;
    }

    @Override
    public int getMaxGroupSize() {
        return 4;
    }

    @Override
    public void birthChildren() {
        int numberOfChildren = ConfigTFC.Animals.COW.babies;
        for (int i = 0; i < numberOfChildren; ++i) {
            EntityCowTFC baby = new EntityCowTFC(this.field_70170_p, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), (int)CalendarTFC.PLAYER_TIME.getTotalDays());
            baby.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            baby.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
            this.field_70170_p.func_72838_d((Entity)baby);
        }
    }

    @Override
    public long gestationDays() {
        return ConfigTFC.Animals.COW.gestation;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(MILKED, (Object)0L);
    }

    @Override
    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74772_a("milkedTick", this.getMilkedTick());
    }

    @Override
    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setMilkedTick(compound.func_74763_f("milkedTick"));
    }

    @Override
    public boolean func_184645_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        FluidActionResult fillResult = FluidUtil.tryFillContainer((ItemStack)itemstack, (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)new ItemStack(Items.field_151117_aB)), (int)1000, (EntityPlayer)player, (boolean)false);
        if (fillResult.isSuccess()) {
            TextComponentTranslation tooltip;
            if (this.getFamiliarity() > 0.15f && this.isReadyForAnimalProduct()) {
                player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
                this.setProductsCooldown();
                player.func_184611_a(hand, FluidUtil.tryFillContainerAndStow((ItemStack)itemstack, (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)new ItemStack(Items.field_151117_aB)), (IItemHandler)new PlayerInvWrapper(player.field_71071_by), (int)1000, (EntityPlayer)player, (boolean)true).getResult());
            } else if (!this.field_70170_p.field_72995_K && (tooltip = this.getTooltip()) != null) {
                TerraFirmaCraft.getNetwork().sendTo((IMessage)new PacketSimpleMessage(PacketSimpleMessage.MessageCategory.ANIMAL, (ITextComponent)tooltip), (EntityPlayerMP)player);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public double getOldDeathChance() {
        return ConfigTFC.Animals.COW.oldDeathChance;
    }

    @Override
    protected boolean eatFood(@Nonnull ItemStack stack, EntityPlayer player) {
        IFood cap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
        if (cap != null && cap.isRotten()) {
            return false;
        }
        return super.eatFood(stack, player);
    }

    @Override
    public float getAdultFamiliarityCap() {
        return 0.35f;
    }

    @Override
    public int getDaysToAdulthood() {
        return ConfigTFC.Animals.COW.adulthood;
    }

    @Override
    public int getDaysToElderly() {
        return ConfigTFC.Animals.COW.elder;
    }

    @Override
    public boolean isReadyForAnimalProduct() {
        return this.getFamiliarity() > 0.15f && this.hasMilk();
    }

    @Override
    public void setProductsCooldown() {
        this.setMilkedTick(CalendarTFC.PLAYER_TIME.getTicks());
    }

    @Override
    public long getProductsCooldown() {
        return Math.max(0L, (long)ConfigTFC.Animals.COW.milkTicks + this.getMilkedTick() - CalendarTFC.PLAYER_TIME.getTicks());
    }

    @Override
    public TextComponentTranslation getTooltip() {
        if (this.getGender() == IAnimalTFC.Gender.MALE) {
            return new TextComponentTranslation("tfc.tooltip.animal.product.male_milk", new Object[0]);
        }
        if (this.getAge() == IAnimalTFC.Age.OLD) {
            return new TextComponentTranslation("tfc.tooltip.animal.product.old", new Object[]{this.getAnimalName()});
        }
        if (this.getAge() == IAnimalTFC.Age.CHILD) {
            return new TextComponentTranslation("tfc.tooltip.animal.product.young", new Object[]{this.getAnimalName()});
        }
        if (this.getFamiliarity() <= 0.15f) {
            return new TextComponentTranslation("tfc.tooltip.animal.product.low_familiarity", new Object[]{this.getAnimalName()});
        }
        if (!this.hasMilk()) {
            return new TextComponentTranslation("tfc.tooltip.animal.product.no_milk", new Object[]{this.getAnimalName()});
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187562_am;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187560_al;
    }

    protected void func_184651_r() {
        EntityAnimalTFC.addCommonLivestockAI(this, 1.2);
        EntityAnimalTFC.addCommonPreyAI(this, 1.2);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187558_ak;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_COW;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    protected boolean hasMilk() {
        return this.getGender() == IAnimalTFC.Gender.FEMALE && this.getAge() == IAnimalTFC.Age.ADULT && this.getProductsCooldown() == 0L;
    }

    protected long getMilkedTick() {
        return (Long)this.field_70180_af.func_187225_a(MILKED);
    }

    protected void setMilkedTick(long tick) {
        this.field_70180_af.func_187227_b(MILKED, (Object)tick);
    }
}

